dofile(LockOn_Options.script_path.."config.lua")

local gettext = require("i_18n")
_ = gettext.translate

device_timer_dt	= 0.2

TFOV    = 100

dynamically_update_geometry = true

page_names = {}

function set_page_name (mode,name)
	
	local L1 = mode[1] or 0

	if page_names[L1] == nil then
	   page_names[L1] =  {}
	end
	
	page_names[L1] = name
	
end

-- master modes
K14_OFF			= 0
K14_ON			= 1 

set_page_name({K14_OFF},"OFF")
set_page_name({K14_ON},"ON")

Dmin = 600
Dmax = 2400
Dmin2 = 250

Lmin = 30
Lmax = 120

kD = 1 / (math.log(Dmax) - math.log(Dmin))
bD = -kD * math.log(Dmin)

kL = 1 / (math.log(Lmax) - math.log(Lmin))
bL = -kL * math.log(Lmin)

K_DL = math.log(Dmax/Dmin) / math.log(Lmax/Lmin)

Ang_max_L = 25
Ang_max_D = Ang_max_L * K_DL

RelAngleMax = math.rad(14.15)

K_ang_L = math.rad(Ang_max_L)
K_ang_D = math.rad(Ang_max_D)
	

K14_NO_POWER_SUPPLY  	  = 0
K14_FIXED_LAMP_DEFECTIVE  = 1
K14_MOV_LAMP_DEFECTIVE    = 2
K14_MOTOR_DEFECTIVE		  = 3

Damage = {	
	{Failure = K14_NO_POWER_SUPPLY, Failure_name = "K14_NO_POWER_SUPPLY", Failure_editor_name = _("K-14. No power supply."),  Element = 3, Integrity_Treshold = 0.3, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = K14_FIXED_LAMP_DEFECTIVE, Failure_name = "K14_FIXED_LAMP_DEFECTIVE", Failure_editor_name = _("K-14. Fixed reticle lamp defective"),  Element = 3, Integrity_Treshold = 0.3, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = K14_MOV_LAMP_DEFECTIVE, Failure_name = "K14_MOV_LAMP_DEFECTIVE", Failure_editor_name = _("K-14. Movable reticle lamp defective"),  Element = 3, Integrity_Treshold = 0.3, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
	{Failure = K14_MOTOR_DEFECTIVE, Failure_name = "K14_MOTOR_DEFECTIVE", Failure_editor_name = _("K-14. Motor defective"),  Element = 3, Integrity_Treshold = 0.3, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
}

ElecConsumerParamsSightBulb = {12, true}
ElecConsumerParamsSightGyro = {5, true, 8, 10}

need_to_be_closed = true -- close lua state after initialization
